<!DOCTYPE html>
<html lang="en" itemscope itemtype="https://schema.org/AboutPage">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- Primary Meta Tags -->
    <title>About Us - Free Video Downloader | VideoDownloader</title>
    <meta name="title" content="About Us - Free Video Downloader | VideoDownloader">
    <meta name="description" content="Learn about VideoDownloader - your trusted free online video downloader. Download Facebook, YouTube, Instagram videos safely and securely.">
    <meta name="keywords" content="about video downloader, free video download, online video downloader, download videos free">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="https://www.yoursite.com/about.php">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://www.yoursite.com/about.php">
    <meta property="og:title" content="About Us - VideoDownloader">
    <meta property="og:description" content="Learn about VideoDownloader - your trusted free online video downloader service.">
    <meta property="og:image" content="https://www.yoursite.com/images/og-image.jpg">
    
    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:url" content="https://www.yoursite.com/about.php">
    <meta name="twitter:title" content="About Us - VideoDownloader">
    <meta name="twitter:description" content="Learn about VideoDownloader - your trusted free online video downloader service.">
    <meta name="twitter:image" content="https://www.yoursite.com/images/twitter-image.jpg">
    
    <link rel="stylesheet" href="styles.css">
    
    <!-- Structured Data - AboutPage Schema -->
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "AboutPage",
      "name": "About VideoDownloader",
      "description": "Learn about VideoDownloader - your trusted free online video downloader service.",
      "url": "https://www.yoursite.com/about.php",
      "mainEntity": {
        "@type": "Organization",
        "name": "VideoDownloader",
        "description": "Free online video downloader for Facebook, YouTube, Instagram, and more platforms."
      }
    }
    </script>
    
    <!-- Breadcrumb Schema -->
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "BreadcrumbList",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.yoursite.com/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "About Us",
          "item": "https://www.yoursite.com/about.php"
        }
      ]
    }
    </script>
    <style>
        .legal-page {
            background: white;
            max-width: 900px;
            margin: 2rem auto;
            padding: 3rem;
            border-radius: 1rem;
            box-shadow: var(--shadow-lg);
        }
        .legal-page h1 {
            color: var(--primary-color);
            margin-bottom: 1rem;
        }
        .legal-page h2 {
            color: var(--text-dark);
            margin-top: 2rem;
            margin-bottom: 1rem;
        }
        .legal-page p {
            margin-bottom: 1rem;
            line-height: 1.8;
        }
        .legal-page ul {
            margin-left: 2rem;
            margin-bottom: 1rem;
        }
        .legal-page li {
            margin-bottom: 0.5rem;
        }
        .back-link {
            display: inline-block;
            color: var(--primary-color);
            text-decoration: none;
            margin-bottom: 2rem;
            font-weight: 600;
        }
        .back-link:hover {
            text-decoration: underline;
        }
        .feature-box {
            background: var(--bg-light);
            padding: 1.5rem;
            border-radius: 0.5rem;
            margin: 1rem 0;
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="container">
            <div class="nav-brand">
                <span class="brand-name">VideoDownloader</span>
            </div>
        </div>
    </nav>

    <div class="container">
        <div class="legal-page">
            <a href="index.php" class="back-link">← Back to Home</a>
            
            <h1>About VideoDownloader</h1>

            <h2>Our Mission</h2>
            <p>VideoDownloader is dedicated to providing a fast, free, and user-friendly platform for downloading videos from popular social media platforms. We believe in making online content accessible to everyone while respecting copyright and platform terms of service.</p>

            <h2>What We Offer</h2>
            <div class="feature-box">
                <h3>🎥 Multi-Platform Support</h3>
                <p>Download videos from Facebook, YouTube, Instagram, and more platforms with just a few clicks.</p>
            </div>

            <div class="feature-box">
                <h3>⚡ Fast & Reliable</h3>
                <p>Our advanced technology ensures quick processing and high-quality downloads every time.</p>
            </div>

            <div class="feature-box">
                <h3>🔒 Safe & Secure</h3>
                <p>We prioritize your privacy and security. No personal data is stored, and all downloads are processed securely.</p>
            </div>

            <div class="feature-box">
                <h3>💯 100% Free</h3>
                <p>All our services are completely free. No hidden fees, no registration required.</p>
            </div>

            <h2>How It Works</h2>
            <ol>
                <li><strong>Copy Video URL:</strong> Find the video you want to download and copy its URL</li>
                <li><strong>Paste URL:</strong> Paste the URL into our input field</li>
                <li><strong>Choose Quality:</strong> Select your preferred video quality</li>
                <li><strong>Download:</strong> Click download and save the video to your device</li>
            </ol>

            <h2>Supported Platforms</h2>
            <ul>
                <li><strong>Facebook:</strong> Download videos, live streams, and stories</li>
                <li><strong>YouTube:</strong> Download videos in various qualities including 4K</li>
                <li><strong>Instagram:</strong> Download videos, Reels, and IGTV content</li>
                <li><strong>More platforms coming soon!</strong></li>
            </ul>

            <h2>Our Commitment</h2>
            <p>We are committed to:</p>
            <ul>
                <li>Providing the best user experience possible</li>
                <li>Maintaining high service quality and uptime</li>
                <li>Protecting user privacy and data</li>
                <li>Complying with all applicable laws and regulations</li>
                <li>Respecting intellectual property rights</li>
            </ul>

            <h2>Disclaimer</h2>
            <p>VideoDownloader is a tool for personal use only. Users are responsible for respecting copyright laws and the terms of service of the respective platforms. We do not host any videos on our servers and only provide links to content that is publicly available.</p>

            <h2>Contact Us</h2>
            <p>Have questions, suggestions, or feedback? We'd love to hear from you! Visit our <a href="contact.php">contact page</a> to get in touch.</p>
        </div>
    </div>

    <footer class="footer">
        <div class="container">
            <div class="footer-bottom">
                <p>&copy; 2025 VideoDownloader. All rights reserved.</p>
            </div>
        </div>
    </footer>
</body>
</html>
