<?php
/**
 * Configuration File for VideoDownloader
 * 
 * This file contains all the configuration settings for the application.
 * Modify these settings according to your needs.
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    define('ABSPATH', dirname(__FILE__) . '/');
}

// Set charset
if (function_exists('mb_internal_encoding')) {
    mb_internal_encoding('UTF-8');
}

// Site Settings
define('SITE_NAME', 'VideoDownloader');
define('SITE_URL', 'https://yourdomain.com'); // Change to your domain
define('SITE_EMAIL', 'support@yourdomain.com'); // Change to your email
define('SITE_DESCRIPTION', 'Free online video downloader for Facebook, YouTube, Instagram. Download videos in HD quality instantly.');
define('SITE_KEYWORDS', 'video downloader, download facebook video, youtube downloader, instagram video downloader, free video download');
define('SITE_AUTHOR', 'VideoDownloader');
define('SITE_LOGO', SITE_URL . '/images/logo.png');
define('SITE_OG_IMAGE', SITE_URL . '/images/og-image.jpg');
define('SITE_TWITTER_HANDLE', '@videodownloader');

// API Keys (Add your API keys here)
// You'll need to sign up for these services to get working download functionality

// RapidAPI Key (for video downloading services)
define('RAPIDAPI_KEY', 'your_rapidapi_key_here');
define('RAPIDAPI_HOST_FACEBOOK', 'facebook-video-and-reels-downloader.p.rapidapi.com');
define('RAPIDAPI_HOST_YOUTUBE', 'youtube-mp3-download1.p.rapidapi.com');
define('RAPIDAPI_HOST_INSTAGRAM', 'instagram-downloader-download-instagram-videos-stories.p.rapidapi.com');

// Google AdSense Settings
define('ADSENSE_CLIENT_ID', 'ca-pub-XXXXXXXXXXXXXXXXX'); // Replace with your AdSense Client ID
define('ADSENSE_SLOT_SIDEBAR', 'XXXXXXXXXX'); // Sidebar ad slot
define('ADSENSE_SLOT_BOTTOM', 'XXXXXXXXXX'); // Bottom ad slot

// Database Settings (if you want to log downloads or save data)
define('DB_HOST', 'localhost');
define('DB_NAME', 'videodownloader');
define('DB_USER', 'root');
define('DB_PASS', '');

// Security Settings
define('ENABLE_RATE_LIMITING', true); // Enable to prevent abuse
define('MAX_REQUESTS_PER_MINUTE', 10); // Maximum requests per IP per minute
define('ENABLE_LOGGING', true); // Log all downloads

// Download Settings
define('MAX_VIDEO_SIZE', 500 * 1024 * 1024); // 500 MB max file size
define('TIMEOUT', 30); // Request timeout in seconds

// Cache Settings
define('ENABLE_CACHE', true);
define('CACHE_DURATION', 3600); // 1 hour in seconds

// Error Reporting (set to false in production)
define('DEBUG_MODE', false);

if (DEBUG_MODE) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

// Timezone
date_default_timezone_set('UTC');

// Supported Platforms
define('SUPPORTED_PLATFORMS', [
    'facebook',
    'youtube',
    'instagram'
]);

// Platform URL Patterns
define('URL_PATTERNS', [
    'facebook' => '/^(https?:\/\/)?(www\.)?(facebook\.com|fb\.watch)\/.+/i',
    'youtube' => '/^(https?:\/\/)?(www\.)?(youtube\.com|youtu\.be)\/.+/i',
    'instagram' => '/^(https?:\/\/)?(www\.)?instagram\.com\/.+/i'
]);

// Quality Options
define('VIDEO_QUALITIES', [
    'facebook' => ['1080p', '720p', '480p', '360p'],
    'youtube' => ['2160p', '1440p', '1080p', '720p', '480p', '360p', 'audio'],
    'instagram' => ['high', 'medium', 'low']
]);

// CORS Settings
define('ALLOW_CORS', true);
define('CORS_ORIGIN', '*'); // Change to specific domain in production

// Helper Functions
function getConfig($key) {
    return defined($key) ? constant($key) : null;
}

function isDebugMode() {
    return DEBUG_MODE;
}

function getSupportedPlatforms() {
    return SUPPORTED_PLATFORMS;
}

function getUrlPattern($platform) {
    return URL_PATTERNS[$platform] ?? null;
}

function getVideoQualities($platform) {
    return VIDEO_QUALITIES[$platform] ?? [];
}
?>
