<!DOCTYPE html>
<html lang="en" itemscope itemtype="https://schema.org/ContactPage">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- Primary Meta Tags -->
    <title>Contact Us - VideoDownloader | Get Support & Send Feedback</title>
    <meta name="title" content="Contact Us - VideoDownloader">
    <meta name="description" content="Contact VideoDownloader support team. Send feedback, report issues, or ask questions about our free video download service. We're here to help!">
    <meta name="keywords" content="contact video downloader, support, customer service, help, feedback">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="https://www.yoursite.com/contact.php">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://www.yoursite.com/contact.php">
    <meta property="og:title" content="Contact Us - VideoDownloader">
    <meta property="og:description" content="Contact VideoDownloader support team for help, feedback, or questions.">
    <meta property="og:image" content="https://www.yoursite.com/images/og-image.jpg">
    
    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:url" content="https://www.yoursite.com/contact.php">
    <meta name="twitter:title" content="Contact Us - VideoDownloader">
    <meta name="twitter:description" content="Contact VideoDownloader support team for help, feedback, or questions.">
    <meta name="twitter:image" content="https://www.yoursite.com/images/twitter-image.jpg">
    
    <link rel="stylesheet" href="styles.css">
    
    <!-- Breadcrumb Schema -->
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "BreadcrumbList",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.yoursite.com/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Contact Us",
          "item": "https://www.yoursite.com/contact.php"
        }
      ]
    }
    </script>
    <style>
        .legal-page {
            background: white;
            max-width: 900px;
            margin: 2rem auto;
            padding: 3rem;
            border-radius: 1rem;
            box-shadow: var(--shadow-lg);
        }
        .legal-page h1 {
            color: var(--primary-color);
            margin-bottom: 1rem;
        }
        .legal-page h2 {
            color: var(--text-dark);
            margin-top: 2rem;
            margin-bottom: 1rem;
        }
        .legal-page p {
            margin-bottom: 1rem;
            line-height: 1.8;
        }
        .back-link {
            display: inline-block;
            color: var(--primary-color);
            text-decoration: none;
            margin-bottom: 2rem;
            font-weight: 600;
        }
        .back-link:hover {
            text-decoration: underline;
        }
        .contact-form {
            margin-top: 2rem;
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 600;
            color: var(--text-dark);
        }
        .form-group input,
        .form-group textarea,
        .form-group select {
            width: 100%;
            padding: 0.875rem;
            border: 2px solid var(--border-color);
            border-radius: 0.5rem;
            font-family: inherit;
            font-size: 1rem;
            transition: var(--transition);
        }
        .form-group input:focus,
        .form-group textarea:focus,
        .form-group select:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
        }
        .form-group textarea {
            resize: vertical;
            min-height: 150px;
        }
        .submit-btn {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
            color: white;
            padding: 1rem 2.5rem;
            border: none;
            border-radius: 0.5rem;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
        }
        .submit-btn:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-lg);
        }
        .alert {
            padding: 1rem;
            border-radius: 0.5rem;
            margin-bottom: 1.5rem;
        }
        .alert-success {
            background: #d1fae5;
            color: var(--success-color);
            border-left: 4px solid var(--success-color);
        }
        .alert-error {
            background: #fee2e2;
            color: var(--error-color);
            border-left: 4px solid var(--error-color);
        }
        .contact-info {
            background: var(--bg-light);
            padding: 1.5rem;
            border-radius: 0.5rem;
            margin-top: 2rem;
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="container">
            <div class="nav-brand">
                <span class="brand-name">VideoDownloader</span>
            </div>
        </div>
    </nav>

    <div class="container">
        <div class="legal-page">
            <a href="index.php" class="back-link">← Back to Home</a>
            
            <h1>Contact Us</h1>
            <p>Have questions, feedback, or need support? We're here to help! Fill out the form below and we'll get back to you as soon as possible.</p>

            <?php
            $messageSent = false;
            $errorMessage = '';

            if ($_SERVER['REQUEST_METHOD'] === 'POST') {
                $name = trim($_POST['name'] ?? '');
                $email = trim($_POST['email'] ?? '');
                $subject = trim($_POST['subject'] ?? '');
                $message = trim($_POST['message'] ?? '');

                // Validation
                if (empty($name) || empty($email) || empty($subject) || empty($message)) {
                    $errorMessage = 'Please fill in all fields.';
                } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    $errorMessage = 'Please enter a valid email address.';
                } else {
                    // Process the form (send email, save to database, etc.)
                    // For demonstration, we'll just show a success message
                    
                    // Example: Send email (configure your mail server)
                    /*
                    $to = 'support@videodownloader.com';
                    $headers = "From: $email\r\n";
                    $headers .= "Reply-To: $email\r\n";
                    $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
                    
                    $emailBody = "<h2>Contact Form Submission</h2>";
                    $emailBody .= "<p><strong>Name:</strong> $name</p>";
                    $emailBody .= "<p><strong>Email:</strong> $email</p>";
                    $emailBody .= "<p><strong>Subject:</strong> $subject</p>";
                    $emailBody .= "<p><strong>Message:</strong><br>$message</p>";
                    
                    if (mail($to, "Contact Form: $subject", $emailBody, $headers)) {
                        $messageSent = true;
                    } else {
                        $errorMessage = 'Failed to send message. Please try again later.';
                    }
                    */
                    
                    // For now, just show success
                    $messageSent = true;
                }
            }
            ?>

            <?php if ($messageSent): ?>
                <div class="alert alert-success">
                    <strong>Success!</strong> Your message has been sent. We'll get back to you soon!
                </div>
            <?php endif; ?>

            <?php if ($errorMessage): ?>
                <div class="alert alert-error">
                    <strong>Error!</strong> <?php echo htmlspecialchars($errorMessage); ?>
                </div>
            <?php endif; ?>

            <form method="POST" action="contact.php" class="contact-form">
                <div class="form-group">
                    <label for="name">Your Name *</label>
                    <input type="text" id="name" name="name" required value="<?php echo htmlspecialchars($_POST['name'] ?? ''); ?>">
                </div>

                <div class="form-group">
                    <label for="email">Your Email *</label>
                    <input type="email" id="email" name="email" required value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>">
                </div>

                <div class="form-group">
                    <label for="subject">Subject *</label>
                    <select id="subject" name="subject" required>
                        <option value="">Select a subject</option>
                        <option value="General Inquiry">General Inquiry</option>
                        <option value="Technical Support">Technical Support</option>
                        <option value="Feature Request">Feature Request</option>
                        <option value="Bug Report">Bug Report</option>
                        <option value="Copyright Issue">Copyright Issue</option>
                        <option value="Business Inquiry">Business Inquiry</option>
                        <option value="Other">Other</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="message">Your Message *</label>
                    <textarea id="message" name="message" required><?php echo htmlspecialchars($_POST['message'] ?? ''); ?></textarea>
                </div>

                <button type="submit" class="submit-btn">Send Message</button>
            </form>

            <div class="contact-info">
                <h2>Other Ways to Reach Us</h2>
                <p><strong>Email:</strong> support@videodownloader.com</p>
                <p><strong>Response Time:</strong> We typically respond within 24-48 hours</p>
                <p><strong>Business Hours:</strong> Monday - Friday, 9:00 AM - 5:00 PM (EST)</p>
            </div>

            <h2>Frequently Asked Questions</h2>
            <p>Before contacting us, you might find answers to common questions:</p>
            <ul>
                <li><strong>Is the service free?</strong> Yes, all our services are 100% free.</li>
                <li><strong>Do I need to register?</strong> No registration is required.</li>
                <li><strong>What formats are supported?</strong> We support MP4, WebM, and audio formats.</li>
                <li><strong>Is it legal?</strong> Users are responsible for complying with copyright laws and platform terms of service.</li>
            </ul>
        </div>
    </div>

    <footer class="footer">
        <div class="container">
            <div class="footer-bottom">
                <p>&copy; 2025 VideoDownloader. All rights reserved.</p>
            </div>
        </div>
    </footer>
</body>
</html>
