<?php
header('Content-Type: text/html; charset=UTF-8');
?>
<!DOCTYPE html>
<html lang="en" itemscope itemtype="https://schema.org/WebApplication">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- Primary Meta Tags -->
    <title>Free Video Downloader - Download Facebook, YouTube & Instagram Videos Online | HD Quality</title>
    <meta name="title" content="Free Video Downloader - Download Facebook, YouTube & Instagram Videos Online | HD Quality">
    <meta name="description" content="Download videos from Facebook, YouTube, Instagram for FREE. Fast, secure, no registration required. Support for HD, 4K quality. Download Reels, IGTV, YouTube videos instantly.">
    <meta name="keywords" content="video downloader, download facebook video, youtube downloader, instagram video downloader, download reels, download youtube, fb video downloader, free video download, online video downloader, HD video download, 4K video downloader, IGTV downloader, youtube to mp4, facebook video save">
    <meta name="author" content="VideoDownloader">
    <meta name="robots" content="index, follow, max-image-preview:large, max-snippet:-1, max-video-preview:-1">
    <meta name="googlebot" content="index, follow">
    <link rel="canonical" href="https://www.yoursite.com/">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://www.yoursite.com/">
    <meta property="og:title" content="Free Video Downloader - Download Facebook, YouTube & Instagram Videos">
    <meta property="og:description" content="Download videos from Facebook, YouTube, Instagram for FREE. Fast, secure, no registration required. Support for HD, 4K quality.">
    <meta property="og:image" content="https://www.yoursite.com/images/og-image.jpg">
    <meta property="og:site_name" content="VideoDownloader">
    <meta property="og:locale" content="en_US">
    
    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:url" content="https://www.yoursite.com/">
    <meta name="twitter:title" content="Free Video Downloader - Download Facebook, YouTube & Instagram Videos">
    <meta name="twitter:description" content="Download videos from Facebook, YouTube, Instagram for FREE. Fast, secure, no registration required.">
    <meta name="twitter:image" content="https://www.yoursite.com/images/twitter-image.jpg">
    
    <!-- Schema.org Markup -->
    <meta itemprop="name" content="VideoDownloader - Free Online Video Downloader">
    <meta itemprop="description" content="Download videos from Facebook, YouTube, Instagram for FREE. Fast, secure, no registration required.">
    <meta itemprop="image" content="https://www.yoursite.com/images/logo.png">
    
    <!-- Additional SEO Meta Tags -->
    <meta name="theme-color" content="#2563eb">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="VideoDownloader">
    <meta name="application-name" content="VideoDownloader">
    <meta name="msapplication-TileColor" content="#2563eb">
    
    <!-- Performance & Resource Hints -->
    <link rel="dns-prefetch" href="https://fonts.googleapis.com">
    <link rel="dns-prefetch" href="https://fonts.gstatic.com">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="icon" type="image/x-icon" href="data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'><text y='.9em' font-size='90'>📥</text></svg>">
    
    <!-- Structured Data - WebApplication Schema -->
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "WebApplication",
      "name": "VideoDownloader",
      "url": "https://www.yoursite.com",
      "description": "Free online video downloader for Facebook, YouTube, and Instagram. Download videos in HD quality instantly.",
      "applicationCategory": "MultimediaApplication",
      "operatingSystem": "All",
      "offers": {
        "@type": "Offer",
        "price": "0",
        "priceCurrency": "USD"
      },
      "aggregateRating": {
        "@type": "AggregateRating",
        "ratingValue": "4.8",
        "ratingCount": "50000"
      },
      "author": {
        "@type": "Organization",
        "name": "VideoDownloader"
      }
    }
    </script>
    
    <!-- Structured Data - Organization Schema -->
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "Organization",
      "name": "VideoDownloader",
      "url": "https://www.yoursite.com",
      "logo": "https://www.yoursite.com/images/logo.png",
      "sameAs": [
        "https://www.facebook.com/yourpage",
        "https://twitter.com/yourhandle"
      ],
      "contactPoint": {
        "@type": "ContactPoint",
        "contactType": "Customer Support",
        "email": "support@videodownloader.com"
      }
    }
    </script>
    
    <!-- Structured Data - BreadcrumbList Schema -->
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "BreadcrumbList",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.yoursite.com/"
        }
      ]
    }
    </script>
</head>
<body>
    <!-- Preloader -->
    <div id="preloader">
        <div class="preloader-content">
            <div class="spinner"></div>
            <p>Loading...</p>
        </div>
    </div>

    <!-- Top Navigation -->
    <nav class="navbar">
        <div class="container">
            <div class="nav-brand">
                <svg class="logo-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M21 15V19C21 19.5304 20.7893 20.0391 20.4142 20.4142C20.0391 20.7893 19.5304 21 19 21H5C4.46957 21 3.96086 20.7893 3.58579 20.4142C3.21071 20.0391 3 19.5304 3 19V15" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M7 10L12 15L17 10" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M12 15V3" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
                <span class="brand-name">VideoDownloader</span>
            </div>
            <ul class="nav-menu">
                <li><a href="#home" class="nav-link active">Home</a></li>
                <li><a href="#facebook" class="nav-link">Facebook</a></li>
                <li><a href="#youtube" class="nav-link">YouTube</a></li>
                <li><a href="#instagram" class="nav-link">Instagram</a></li>
                <li><a href="#tools" class="nav-link">Other Tools</a></li>
            </ul>
            <button class="mobile-menu-toggle" aria-label="Toggle menu">
                <span></span>
                <span></span>
                <span></span>
            </button>
        </div>
    </nav>

    <!-- Hero Section -->
    <section id="home" class="hero" itemscope itemtype="https://schema.org/SoftwareApplication">
        <meta itemprop="name" content="VideoDownloader">
        <meta itemprop="applicationCategory" content="MultimediaApplication">
        <meta itemprop="operatingSystem" content="All">
        <div class="wave-container">
            <svg class="wave" viewBox="0 0 1200 120" preserveAspectRatio="none">
                <path d="M321.39,56.44c58-10.79,114.16-30.13,172-41.86,82.39-16.72,168.19-17.73,250.45-.39C823.78,31,906.67,72,985.66,92.83c70.05,18.48,146.53,26.09,214.34,3V0H0V27.35A600.21,600.21,0,0,0,321.39,56.44Z" fill="currentColor"></path>
            </svg>
        </div>
        <div class="container hero-content">
            <h1 class="hero-title" itemprop="headline">Download Videos from Any Platform - Free & Fast</h1>
            <p class="hero-subtitle" itemprop="description">Fast, free, and easy video downloading from Facebook, YouTube, Instagram, and more. No registration required. HD & 4K quality supported.</p>
            <div class="hero-stats">
                <div class="stat-item">
                    <div class="stat-number" data-target="50000">0</div>
                    <div class="stat-label">Happy Users</div>
                </div>
                <div class="stat-item">
                    <div class="stat-number" data-target="1000000">0</div>
                    <div class="stat-label">Videos Downloaded</div>
                </div>
                <div class="stat-item">
                    <div class="stat-number" data-target="3">0</div>
                    <div class="stat-label">Platforms Supported</div>
                </div>
            </div>
            <div class="platform-selector">
                <button class="platform-btn active" data-platform="facebook">
                    <svg viewBox="0 0 24 24" fill="currentColor">
                        <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                    </svg>
                    Facebook
                </button>
                <button class="platform-btn" data-platform="youtube">
                    <svg viewBox="0 0 24 24" fill="currentColor">
                        <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/>
                    </svg>
                    YouTube
                </button>
                <button class="platform-btn" data-platform="instagram">
                    <svg viewBox="0 0 24 24" fill="currentColor">
                        <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                    </svg>
                    Instagram
                </button>
            </div>
        </div>
    </section>

    <!-- Main Content with Sidebar -->
    <div class="main-wrapper">
        <div class="container">
            <div class="content-grid">
                <!-- Main Content Area -->
                <main class="main-content">
                    <!-- Facebook Downloader -->
                    <section id="facebook" class="downloader-section active" itemscope itemtype="https://schema.org/HowTo">
                        <meta itemprop="name" content="How to Download Facebook Videos">
                        <meta itemprop="description" content="Download Facebook videos in HD quality for free">
                        <div class="section-header">
                            <div class="platform-icon facebook-icon">
                                <svg viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                                </svg>
                            </div>
                            <div>
                                <h2 class="section-title" itemprop="name">Facebook Video Downloader - Free FB Video Download</h2>
                                <p class="section-description" itemprop="description">Download Facebook videos in HD quality. Save FB videos, live streams, and stories instantly. No watermark, 100% free.</p>
                            </div>
                        </div>
                        <div class="input-group">
                            <input type="text" class="video-url-input" id="facebook-url" placeholder="Paste Facebook video URL here...">
                            <button class="download-btn facebook-btn" onclick="downloadVideo('facebook')">
                                <svg class="btn-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                    <path d="M21 15V19C21 19.5304 20.7893 20.0391 20.4142 20.4142C20.0391 20.7893 19.5304 21 19 21H5C4.46957 21 3.96086 20.7893 3.58579 20.4142C3.21071 20.0391 3 19.5304 3 19V15" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M7 10L12 15L17 10" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M12 15V3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                <span class="btn-text">Download Facebook Video</span>
                                <span class="spinner"></span>
                            </button>
                        </div>
                        <div class="result-container" id="facebook-result"></div>
                    </section>

                    <!-- YouTube Downloader -->
                    <section id="youtube" class="downloader-section" itemscope itemtype="https://schema.org/HowTo">
                        <meta itemprop="name" content="How to Download YouTube Videos">
                        <meta itemprop="description" content="Download YouTube videos in multiple formats and quality">
                        <div class="section-header">
                            <div class="platform-icon youtube-icon">
                                <svg viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/>
                                </svg>
                            </div>
                            <div>
                                <h2 class="section-title" itemprop="name">YouTube Video Downloader - Download YouTube to MP4, 4K, HD</h2>
                                <p class="section-description" itemprop="description">Download YouTube videos and audio in multiple formats. Support MP4, WebM, MP3. Download in 4K, 1080p, 720p, 480p quality.</p>
                            </div>
                        </div>
                        <div class="input-group">
                            <input type="text" class="video-url-input" id="youtube-url" placeholder="Paste YouTube video URL here...">
                            <button class="download-btn youtube-btn" onclick="downloadVideo('youtube')">
                                <svg class="btn-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                    <path d="M21 15V19C21 19.5304 20.7893 20.0391 20.4142 20.4142C20.0391 20.7893 19.5304 21 19 21H5C4.46957 21 3.96086 20.7893 3.58579 20.4142C3.21071 20.0391 3 19.5304 3 19V15" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M7 10L12 15L17 10" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M12 15V3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                <span class="btn-text">Download YouTube Video</span>
                                <span class="spinner"></span>
                            </button>
                        </div>
                        <div class="result-container" id="youtube-result"></div>
                    </section>

                    <!-- Instagram Downloader -->
                    <section id="instagram" class="downloader-section" itemscope itemtype="https://schema.org/HowTo">
                        <meta itemprop="name" content="How to Download Instagram Videos">
                        <meta itemprop="description" content="Download Instagram videos, Reels, IGTV, and Stories">
                        <div class="section-header">
                            <div class="platform-icon instagram-icon">
                                <svg viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                                </svg>
                            </div>
                            <div>
                                <h2 class="section-title" itemprop="name">Instagram Video Downloader - Download Reels, IGTV, Stories</h2>
                                <p class="section-description" itemprop="description">Download Instagram videos, Reels, IGTV, and Stories in HD quality. Save Instagram content to your device instantly.</p>
                            </div>
                        </div>
                        <div class="input-group">
                            <input type="text" class="video-url-input" id="instagram-url" placeholder="Paste Instagram video URL here...">
                            <button class="download-btn instagram-btn" onclick="downloadVideo('instagram')">
                                <svg class="btn-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                    <path d="M21 15V19C21 19.5304 20.7893 20.0391 20.4142 20.4142C20.0391 20.7893 19.5304 21 19 21H5C4.46957 21 3.96086 20.7893 3.58579 20.4142C3.21071 20.0391 3 19.5304 3 19V15" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M7 10L12 15L17 10" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M12 15V3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                <span class="btn-text">Download Instagram Video</span>
                                <span class="spinner"></span>
                            </button>
                        </div>
                        <div class="result-container" id="instagram-result"></div>
                    </section>

                    <!-- Features Section -->
                    <section class="features-showcase" itemscope itemtype="https://schema.org/ItemList">
                        <h2 class="section-title">Why Choose Our Free Video Downloader Service?</h2>
                        <meta itemprop="name" content="VideoDownloader Features">
                        <div class="features-grid">
                            <div class="feature-card">
                                <div class="feature-icon">
                                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                        <path d="M13 10V3L4 14h7v7l9-11h-7z" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <h3>Lightning Fast</h3>
                                <p>Download videos in seconds with our optimized servers</p>
                            </div>
                            <div class="feature-card">
                                <div class="feature-icon">
                                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                        <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <h3>100% Secure</h3>
                                <p>Your privacy is protected. No data stored or shared</p>
                            </div>
                            <div class="feature-card">
                                <div class="feature-icon">
                                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                        <circle cx="12" cy="12" r="10" stroke-width="2"/>
                                        <path d="M12 6v6l4 2" stroke-width="2" stroke-linecap="round"/>
                                    </svg>
                                </div>
                                <h3>24/7 Available</h3>
                                <p>Download anytime, anywhere, on any device</p>
                            </div>
                            <div class="feature-card">
                                <div class="feature-icon">
                                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                        <path d="M12 2L2 7l10 5 10-5-10-5z" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M2 17l10 5 10-5M2 12l10 5 10-5" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <h3>Multiple Formats</h3>
                                <p>Choose from various quality options and formats</p>
                            </div>
                            <div class="feature-card">
                                <div class="feature-icon">
                                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                        <rect x="2" y="2" width="20" height="20" rx="2.18" ry="2.18" stroke-width="2"/>
                                        <line x1="7" y1="2" x2="7" y2="22" stroke-width="2"/>
                                        <line x1="17" y1="2" x2="17" y2="22" stroke-width="2"/>
                                        <line x1="2" y1="12" x2="22" y2="12" stroke-width="2"/>
                                        <line x1="2" y1="7" x2="7" y2="7" stroke-width="2"/>
                                        <line x1="2" y1="17" x2="7" y2="17" stroke-width="2"/>
                                        <line x1="17" y1="17" x2="22" y2="17" stroke-width="2"/>
                                        <line x1="17" y1="7" x2="22" y2="7" stroke-width="2"/>
                                    </svg>
                                </div>
                                <h3>No Registration</h3>
                                <p>Start downloading immediately. No signup required</p>
                            </div>
                            <div class="feature-card">
                                <div class="feature-icon">
                                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                        <path d="M20.59 13.41l-7.17 7.17a2 2 0 0 1-2.83 0L2 12V2h10l8.59 8.59a2 2 0 0 1 0 2.82z" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <line x1="7" y1="7" x2="7.01" y2="7" stroke-width="2" stroke-linecap="round"/>
                                    </svg>
                                </div>
                                <h3>Completely Free</h3>
                                <p>All features available at no cost. Forever free</p>
                            </div>
                        </div>
                    </section>

                    <!-- Other Tools Section -->
                    <section id="tools" class="tools-section">
                        <h2 class="section-title">Other Tools & Features</h2>
                        <div class="tools-grid">
                            <div class="tool-card">
                                <svg class="tool-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                    <rect x="3" y="3" width="18" height="18" rx="2" ry="2" stroke-width="2"/>
                                    <circle cx="8.5" cy="8.5" r="1.5" fill="currentColor"/>
                                    <path d="M21 15L16 10L5 21" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                <h3>Video to GIF</h3>
                                <p>Convert videos to animated GIFs</p>
                            </div>
                            <div class="tool-card">
                                <svg class="tool-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                    <path d="M23 7L16 12L23 17V7Z" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    <polygon points="1 5 15 5 15 19 1 19 1 5" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                <h3>Video Compressor</h3>
                                <p>Reduce video file size</p>
                            </div>
                            <div class="tool-card">
                                <svg class="tool-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                    <path d="M3 9L12 2L21 9V20C21 20.5304 20.7893 21.0391 20.4142 21.4142C20.0391 21.7893 19.5304 22 19 22H5C4.46957 22 3.96086 21.7893 3.58579 21.4142C3.21071 21.0391 3 20.5304 3 20V9Z" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M9 22V12H15V22" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                <h3>Audio Extractor</h3>
                                <p>Extract audio from videos</p>
                            </div>
                            <div class="tool-card">
                                <svg class="tool-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                    <circle cx="12" cy="12" r="10" stroke-width="2"/>
                                    <polygon points="10 8 16 12 10 16 10 8" fill="currentColor"/>
                                </svg>
                                <h3>Video Player</h3>
                                <p>Preview before download</p>
                            </div>
                        </div>
                    </section>

                    <!-- Bottom Ad Section -->
                    <div class="ad-block bottom-ad">
                        <!-- AdSense Ad Code -->
                        <div class="ad-placeholder">
                            <p>Advertisement</p>
                            <!-- Replace with your AdSense code -->
                            <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                            <ins class="adsbygoogle"
                                 style="display:block"
                                 data-ad-client="ca-pub-XXXXXXXXXX"
                                 data-ad-slot="XXXXXXXXXX"
                                 data-ad-format="auto"
                                 data-full-width-responsive="true"></ins>
                            <script>
                                 (adsbygoogle = window.adsbygoogle || []).push({});
                            </script>
                        </div>
                    </div>
                </main>

                <!-- Right Sidebar with Ads -->
                <aside class="sidebar">
                    <div class="ad-block sidebar-ad sticky">
                        <div class="ad-placeholder">
                            <p>Advertisement</p>
                            <!-- Replace with your AdSense code -->
                            <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                            <ins class="adsbygoogle"
                                 style="display:block"
                                 data-ad-client="ca-pub-XXXXXXXXXX"
                                 data-ad-slot="XXXXXXXXXX"
                                 data-ad-format="auto"
                                 data-full-width-responsive="true"></ins>
                            <script>
                                 (adsbygoogle = window.adsbygoogle || []).push({});
                            </script>
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="footer" itemscope itemtype="https://schema.org/WPFooter">
        <div class="wave-container footer-wave">
            <svg class="wave" viewBox="0 0 1200 120" preserveAspectRatio="none">
                <path d="M321.39,56.44c58-10.79,114.16-30.13,172-41.86,82.39-16.72,168.19-17.73,250.45-.39C823.78,31,906.67,72,985.66,92.83c70.05,18.48,146.53,26.09,214.34,3V0H0V27.35A600.21,600.21,0,0,0,321.39,56.44Z" fill="currentColor"></path>
            </svg>
        </div>
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <h3 class="footer-title">VideoDownloader</h3>
                    <p class="footer-text">Free, fast, and secure video downloading from multiple platforms.</p>
                </div>
                <div class="footer-section">
                    <h4 class="footer-heading">Quick Links</h4>
                    <ul class="footer-links">
                        <li><a href="#home">Home</a></li>
                        <li><a href="#facebook">Facebook Downloader</a></li>
                        <li><a href="#youtube">YouTube Downloader</a></li>
                        <li><a href="#instagram">Instagram Downloader</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4 class="footer-heading">Legal</h4>
                    <ul class="footer-links">
                        <li><a href="privacy.php">Privacy Policy</a></li>
                        <li><a href="about.php">About Us</a></li>
                        <li><a href="contact.php">Contact</a></li>
                        <li><a href="terms.php">Terms of Service</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4 class="footer-heading">Disclaimer</h4>
                    <p class="footer-text small">This service is provided for personal use only. Please respect copyright and terms of service of the respective platforms.</p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; 2025 VideoDownloader. All rights reserved.</p>
                <p class="google-compliance">Google AdSense Publisher - Compliant with Google Policies</p>
            </div>
        </div>
    </footer>

    <!-- Back to Top Button -->
    <button id="backToTop" class="back-to-top" aria-label="Back to top">
        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor">
            <path d="M18 15l-6-6-6 6" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
        </svg>
    </button>

    <script src="script.js"></script>
</body>
</html>
