<!DOCTYPE html>
<html lang="en" itemscope itemtype="https://schema.org/WebPage">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- Primary Meta Tags -->
    <title>Privacy Policy - VideoDownloader | Your Privacy is Protected</title>
    <meta name="title" content="Privacy Policy - VideoDownloader">
    <meta name="description" content="Read our privacy policy to understand how VideoDownloader protects your data. We don't store your videos or personal information. 100% secure and private.">
    <meta name="keywords" content="privacy policy, video downloader privacy, secure video download, data protection">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="https://www.yoursite.com/privacy.php">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://www.yoursite.com/privacy.php">
    <meta property="og:title" content="Privacy Policy - VideoDownloader">
    <meta property="og:description" content="Read our privacy policy to understand how VideoDownloader protects your data and privacy.">
    <meta property="og:image" content="https://www.yoursite.com/images/og-image.jpg">
    
    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:url" content="https://www.yoursite.com/privacy.php">
    <meta name="twitter:title" content="Privacy Policy - VideoDownloader">
    <meta name="twitter:description" content="Read our privacy policy to understand how VideoDownloader protects your data and privacy.">
    <meta name="twitter:image" content="https://www.yoursite.com/images/twitter-image.jpg">
    
    <link rel="stylesheet" href="styles.css">
    
    <!-- Breadcrumb Schema -->
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "BreadcrumbList",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.yoursite.com/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Privacy Policy",
          "item": "https://www.yoursite.com/privacy.php"
        }
      ]
    }
    </script>
    <style>
        .legal-page {
            background: white;
            max-width: 900px;
            margin: 2rem auto;
            padding: 3rem;
            border-radius: 1rem;
            box-shadow: var(--shadow-lg);
        }
        .legal-page h1 {
            color: var(--primary-color);
            margin-bottom: 1rem;
        }
        .legal-page h2 {
            color: var(--text-dark);
            margin-top: 2rem;
            margin-bottom: 1rem;
        }
        .legal-page p {
            margin-bottom: 1rem;
            line-height: 1.8;
        }
        .legal-page ul {
            margin-left: 2rem;
            margin-bottom: 1rem;
        }
        .legal-page li {
            margin-bottom: 0.5rem;
        }
        .back-link {
            display: inline-block;
            color: var(--primary-color);
            text-decoration: none;
            margin-bottom: 2rem;
            font-weight: 600;
        }
        .back-link:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="container">
            <div class="nav-brand">
                <span class="brand-name">VideoDownloader</span>
            </div>
        </div>
    </nav>

    <div class="container">
        <div class="legal-page">
            <a href="index.php" class="back-link">← Back to Home</a>
            
            <h1>Privacy Policy</h1>
            <p><strong>Last Updated:</strong> January 2025</p>

            <h2>1. Introduction</h2>
            <p>Welcome to VideoDownloader. We respect your privacy and are committed to protecting your personal data. This privacy policy will inform you about how we look after your personal data when you visit our website and tell you about your privacy rights.</p>

            <h2>2. Information We Collect</h2>
            <p>We may collect, use, store and transfer different kinds of personal data about you:</p>
            <ul>
                <li><strong>Usage Data:</strong> Information about how you use our website and services</li>
                <li><strong>Technical Data:</strong> IP address, browser type and version, time zone setting, browser plug-in types and versions, operating system and platform</li>
                <li><strong>Video URLs:</strong> The URLs you submit for video downloading (temporarily processed and not stored)</li>
            </ul>

            <h2>3. How We Use Your Information</h2>
            <p>We use your information to:</p>
            <ul>
                <li>Provide video downloading services</li>
                <li>Improve our website and services</li>
                <li>Analyze website usage and trends</li>
                <li>Display relevant advertisements through Google AdSense</li>
                <li>Comply with legal obligations</li>
            </ul>

            <h2>4. Cookies and Tracking</h2>
            <p>We use cookies and similar tracking technologies to track activity on our service and hold certain information. Cookies are files with small amount of data. You can instruct your browser to refuse all cookies or to indicate when a cookie is being sent.</p>

            <h2>5. Google AdSense</h2>
            <p>We use Google AdSense to display advertisements. Google AdSense uses cookies to serve ads based on your prior visits to our website or other websites. You may opt out of personalized advertising by visiting <a href="https://www.google.com/settings/ads" target="_blank">Google Ads Settings</a>.</p>

            <h2>6. Data Security</h2>
            <p>We have implemented appropriate security measures to prevent your personal data from being accidentally lost, used or accessed in an unauthorized way. Video URLs are processed in real-time and are not permanently stored on our servers.</p>

            <h2>7. Third-Party Links</h2>
            <p>Our website may contain links to third-party websites. We have no control over the content and practices of these sites and cannot accept responsibility for their privacy policies.</p>

            <h2>8. Your Legal Rights</h2>
            <p>Under certain circumstances, you have rights under data protection laws in relation to your personal data, including the right to:</p>
            <ul>
                <li>Request access to your personal data</li>
                <li>Request correction of your personal data</li>
                <li>Request erasure of your personal data</li>
                <li>Object to processing of your personal data</li>
                <li>Request restriction of processing your personal data</li>
            </ul>

            <h2>9. Children's Privacy</h2>
            <p>Our service is not directed to children under the age of 13. We do not knowingly collect personally identifiable information from children under 13.</p>

            <h2>10. Changes to This Privacy Policy</h2>
            <p>We may update our Privacy Policy from time to time. We will notify you of any changes by posting the new Privacy Policy on this page and updating the "Last Updated" date.</p>

            <h2>11. Contact Us</h2>
            <p>If you have any questions about this Privacy Policy, please contact us at <a href="contact.php">our contact page</a>.</p>
        </div>
    </div>

    <footer class="footer">
        <div class="container">
            <div class="footer-bottom">
                <p>&copy; 2025 VideoDownloader. All rights reserved.</p>
            </div>
        </div>
    </footer>
</body>
</html>
