<!DOCTYPE html>
<html lang="en" itemscope itemtype="https://schema.org/WebPage">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- Primary Meta Tags -->
    <title>Terms of Service - VideoDownloader | Usage Guidelines & Legal Terms</title>
    <meta name="title" content="Terms of Service - VideoDownloader">
    <meta name="description" content="Read VideoDownloader's terms of service. Understand your rights and responsibilities when using our free video download service.">
    <meta name="keywords" content="terms of service, video downloader terms, usage policy, legal terms">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="https://www.yoursite.com/terms.php">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://www.yoursite.com/terms.php">
    <meta property="og:title" content="Terms of Service - VideoDownloader">
    <meta property="og:description" content="Read VideoDownloader's terms of service and usage guidelines.">
    <meta property="og:image" content="https://www.yoursite.com/images/og-image.jpg">
    
    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:url" content="https://www.yoursite.com/terms.php">
    <meta name="twitter:title" content="Terms of Service - VideoDownloader">
    <meta name="twitter:description" content="Read VideoDownloader's terms of service and usage guidelines.">
    <meta name="twitter:image" content="https://www.yoursite.com/images/twitter-image.jpg">
    
    <link rel="stylesheet" href="styles.css">
    
    <!-- Breadcrumb Schema -->
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "BreadcrumbList",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.yoursite.com/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Terms of Service",
          "item": "https://www.yoursite.com/terms.php"
        }
      ]
    }
    </script>
    <style>
        .legal-page {
            background: white;
            max-width: 900px;
            margin: 2rem auto;
            padding: 3rem;
            border-radius: 1rem;
            box-shadow: var(--shadow-lg);
        }
        .legal-page h1 {
            color: var(--primary-color);
            margin-bottom: 1rem;
        }
        .legal-page h2 {
            color: var(--text-dark);
            margin-top: 2rem;
            margin-bottom: 1rem;
        }
        .legal-page p {
            margin-bottom: 1rem;
            line-height: 1.8;
        }
        .legal-page ul {
            margin-left: 2rem;
            margin-bottom: 1rem;
        }
        .legal-page li {
            margin-bottom: 0.5rem;
        }
        .back-link {
            display: inline-block;
            color: var(--primary-color);
            text-decoration: none;
            margin-bottom: 2rem;
            font-weight: 600;
        }
        .back-link:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="container">
            <div class="nav-brand">
                <span class="brand-name">VideoDownloader</span>
            </div>
        </div>
    </nav>

    <div class="container">
        <div class="legal-page">
            <a href="index.php" class="back-link">← Back to Home</a>
            
            <h1>Terms of Service</h1>
            <p><strong>Last Updated:</strong> January 2025</p>

            <h2>1. Acceptance of Terms</h2>
            <p>By accessing and using VideoDownloader, you accept and agree to be bound by the terms and provision of this agreement. If you do not agree to abide by the above, please do not use this service.</p>

            <h2>2. Use License</h2>
            <p>Permission is granted to temporarily download videos for personal, non-commercial transitory viewing only. This is the grant of a license, not a transfer of title, and under this license you may not:</p>
            <ul>
                <li>Use the content for any commercial purpose</li>
                <li>Modify or copy the materials</li>
                <li>Attempt to decompile or reverse engineer any software contained on VideoDownloader</li>
                <li>Remove any copyright or other proprietary notations from the materials</li>
                <li>Transfer the materials to another person or "mirror" the materials on any other server</li>
            </ul>

            <h2>3. User Responsibilities</h2>
            <p>As a user of this service, you agree to:</p>
            <ul>
                <li>Respect all applicable copyright laws and terms of service of video platforms</li>
                <li>Only download videos you have the right to download</li>
                <li>Not use this service for any illegal or unauthorized purpose</li>
                <li>Not download copyrighted content without permission from the copyright holder</li>
                <li>Not use this service to violate any laws in your jurisdiction</li>
            </ul>

            <h2>4. Disclaimer</h2>
            <p>The materials on VideoDownloader are provided on an 'as is' basis. VideoDownloader makes no warranties, expressed or implied, and hereby disclaims and negates all other warranties including, without limitation, implied warranties or conditions of merchantability, fitness for a particular purpose, or non-infringement of intellectual property or other violation of rights.</p>

            <h2>5. Limitations</h2>
            <p>In no event shall VideoDownloader or its suppliers be liable for any damages (including, without limitation, damages for loss of data or profit, or due to business interruption) arising out of the use or inability to use the materials on VideoDownloader, even if VideoDownloader or a VideoDownloader authorized representative has been notified orally or in writing of the possibility of such damage.</p>

            <h2>6. Accuracy of Materials</h2>
            <p>The materials appearing on VideoDownloader could include technical, typographical, or photographic errors. VideoDownloader does not warrant that any of the materials on its website are accurate, complete or current.</p>

            <h2>7. Links</h2>
            <p>VideoDownloader has not reviewed all of the sites linked to its website and is not responsible for the contents of any such linked site. The inclusion of any link does not imply endorsement by VideoDownloader of the site. Use of any such linked website is at the user's own risk.</p>

            <h2>8. Service Modifications</h2>
            <p>VideoDownloader may revise these terms of service for its website at any time without notice. By using this website you are agreeing to be bound by the then current version of these terms of service.</p>

            <h2>9. Copyright Policy</h2>
            <p>We respect the intellectual property rights of others. If you believe that your copyrighted work has been copied in a way that constitutes copyright infringement, please contact us immediately at our contact page.</p>

            <h2>10. Third-Party Platforms</h2>
            <p>VideoDownloader is not affiliated with, endorsed by, or connected to Facebook, YouTube, Instagram, or any other video platform. All trademarks and copyrights belong to their respective owners.</p>

            <h2>11. Service Availability</h2>
            <p>We do not guarantee that our service will be available at all times or that it will be uninterrupted. We may suspend, withdraw, or restrict the availability of all or any part of our service for business and operational reasons.</p>

            <h2>12. Prohibited Uses</h2>
            <p>You may not use our service:</p>
            <ul>
                <li>To violate any laws or regulations</li>
                <li>To infringe upon or violate our intellectual property rights or the intellectual property rights of others</li>
                <li>To harass, abuse, insult, harm, defame, slander, disparage, intimidate, or discriminate</li>
                <li>To submit false or misleading information</li>
                <li>To upload or transmit viruses or any other type of malicious code</li>
                <li>To spam, phish, pharm, pretext, spider, crawl, or scrape</li>
                <li>For any obscene or immoral purpose</li>
                <li>To interfere with or circumvent the security features of the service</li>
            </ul>

            <h2>13. Termination</h2>
            <p>We may terminate or suspend access to our service immediately, without prior notice or liability, for any reason whatsoever, including without limitation if you breach the Terms.</p>

            <h2>14. Governing Law</h2>
            <p>These terms shall be governed and construed in accordance with applicable laws, without regard to its conflict of law provisions.</p>

            <h2>15. Contact Information</h2>
            <p>If you have any questions about these Terms, please contact us through our <a href="contact.php">contact page</a>.</p>
        </div>
    </div>

    <footer class="footer">
        <div class="container">
            <div class="footer-bottom">
                <p>&copy; 2025 VideoDownloader. All rights reserved.</p>
            </div>
        </div>
    </footer>
</body>
</html>
